<?php
/**
 * This file implements admin stuff, but mainly the onboarding process.
 *
 * @package MI2UINV
 */

namespace MI2UINV;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'MI2U_ZIP_EXPORT_PATH', 'tmp_invoice-zip-' );

use \Automattic\WooCommerce\Utilities\FeaturesUtil;
use WC_Abstract_Order;
use ZipArchive;

/**
 * Get the plugin setting url.
 *
 * @return     string  The setting url.
 */
function settings_url() {
	return admin_url( 'admin.php?page=wc-settings&tab=mi2uinv' );
}

/**
 * Adds invoice columns.
 *
 * @param array $columns The columns.
 *
 * @return array  The columns with added column.
 */
function add_invoice_columns( array $columns ) {
	$columns['invoice'] = __( 'E-Invoice', 'mi2u-eInvoice' );
	add_thickbox();
	return $columns;
}

function add_invoice_submission_status( string $column, $the_order ) {

	if ( 'invoice' === $column ) {
		if ( is_numeric( $the_order ) ) {
			$the_order = wc_get_order( $the_order );
		}
		if ( $the_order instanceof WC_Abstract_Order ) {		
			$title = $the_order->get_order_number();
			$up_ics = $the_order->get_meta('up_ics');
			if($up_ics=='t'||$up_ics=='i'){
				echo '<a class="thickbox"' . esc_attr( $title ) . '"><span >submitted</span></a>';
			}
			else {
				echo '<a class="thickbox"' . esc_attr( $title ) . '"><span>pending</span></a>';
			}
		}
	}
}

add_filter( 'manage_edit-shop_order_columns', __NAMESPACE__ . '\add_invoice_columns', 999 );
add_filter( 'manage_woocommerce_page_wc-orders_columns', __NAMESPACE__ . '\add_invoice_columns', 999 );

add_action( 'manage_shop_order_posts_custom_column', __NAMESPACE__ . '\add_invoice_submission_status', 10, 2 );
add_action( 'manage_woocommerce_page_wc-orders_custom_column', __NAMESPACE__ . '\add_invoice_submission_status', 10, 2 );

/**
 * Adding link to documentation in the plugin row
 */
add_filter(
	'plugin_row_meta',
	function ( $links, $file ) {
		if ( MI2UINV_PLUGIN_BASENAME !== $file ) {
			return $links;
		}

		$row_meta = array(
			'docs' => '<a href="https://www.woo-einvoicing.com/docs/" aria-label="' . esc_attr__( 'View E-Invoicing for WooCommerce documentation', 'mi2u-eInvoice' ) . '">' . esc_html__( 'E-Invoicing Documentation', 'mi2u-eInvoice' ) . '</a>',
		);
		return array_merge( $links, $row_meta );
	},
	10,
	2
);

/**
 * Show upgrade notice
 *
 * @param      array $data      The data.
 * @param      array $response  The response.
 */
function prefix_plugin_update_message( $data, $response ) {
	if ( isset( $response->upgrade_notice ) ) {
		printf(
			'<div class="update-message">%s</div>',
			wp_kses_post( wpautop( $response->upgrade_notice ) )
		);
	}
}
add_action( 'in_plugin_update_message-einvoicing-for-woocommerce/einvoicing-for-woocommerce.php', __NAMESPACE__ . '\prefix_plugin_update_message', 10, 2 );

/**
 * Declare compatibility with WooCommerce
 */
add_action(
	'before_woocommerce_init',
	function () {
		if ( class_exists( FeaturesUtil::class ) ) {
			FeaturesUtil::declare_compatibility( 'custom_order_tables', MI2UINV_PLUGIN_FILE, true );
		}
	}
);

