<?php

/**
 * This file implements the settings tab
 *
 * @package MI2U
 */

namespace MI2UINV;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

use DigitalInvoice\Types;
use DigitalInvoice\InternationalCodeDesignator;
use WC_Settings_Page;
use WC_Admin_Settings;


/**
 * Plugin main settings tab page
 */
class Settings extends WC_Settings_Page
{

	/**
	 * Tab Id
	 *
	 * @inheritdoc
	 * @var string
	 */
	protected $id = 'mi2uinv';

	/**
	 * Constructor.
	 */
	public function __construct()
	{
		$this->label = __('E-Invoicing MI2U', 'mi2u-eInvoice');
		parent::__construct();

		add_action('woocommerce_settings_saved', array($this, 'after_save'));
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
		if (empty($_POST) && isset($_GET['configured']) && '0' === $_GET['configured']) {
			add_action(
				'admin_notices',
				function () {
					$message = __('Before customizing the visual aspect of your invoice, first make sure your settings are properly configured.', 'mi2u-eInvoice');
					printf('<div class="notice notice-error"><p>%s</p></div>', esc_html($message));
				}
			);
		}
	}

	/**
	 * Adds a message after settings are saved.
	 */
	public function after_save()
	{
		global $current_tab;
		if ($this->id === $current_tab) {
			$customized = get_option($this->id . '_customizations', false);
			if (false === $customized) {
				$message = __('Consider checking the invoice customization to complete your setting.', 'mi2u-eInvoice');
				WC_Admin_Settings::add_message($message);
			}
		}
	}


	/**
	 * Gets the settings.
	 *
	 * @return     array  The settings.
	 */
	public function get_settings()
	{

		//$chosen = WC()->session->get('radio_chosen');
    	//$chosen = empty($chosen) ? 'add_text' : $chosen;

		$settings = array(
			'section_title'          => array(
				'name' => __('MI2U secret', 'mi2u-eInvoice'),
				'type' => 'title',
				'id'   => $this->id . '_settings_company',
			),

			'website_option'                  => array(
				'name' => __('Webpage', 'mi2u-eInvoice'),
				'type' => 'radio',
				'options' => array(
					'add_uat' => 'UAT',
					'add_production' => 'Production',
				),
				'desc' => __('Please select server for E-invoicing.', 'mi2u-eInvoice'),
				'id'   => $this->id . '_website_option',
				'default' =>'add_uat',
			),

			'Access_Token'                  => array(
				'name' => __('Access Token', 'mi2u-eInvoice'),
				'type' => 'text',
				'desc' => __('Enter the MI2U Access Token for E-invoicing.', 'mi2u-eInvoice'),
				'id'   => $this->id . '_login_email',
			),

			'section_end'            => array(
				'type' => 'sectionend',
				'id'   => $this->id . '_settings_company_end',
			),
		);

		return $settings;
	}
}

return new Settings();
