<?php

/**
 * Freemius initialisation
 *
 * @package MI2U
 */
namespace MI2UINV;
use WC_Order_Query;

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
if ( !function_exists( 'mi2u_fs' ) ) {
    /**
     * Create a helper function for easy SDK access.
     */
    function mi2u_fs() {
        global $mi2u_fs;
        return $mi2u_fs;
    }

    // Init Freemius.
    mi2u_fs();
    /**
     * Signal that SDK was initiated.
     *
     * @since 0.0.1
     */
    do_action( 'mi2u_fs_loaded' );
 
}
// Onboarding is presented in the dashboard as well.
add_filter( 'mi2u_show_onboarding', function ( $show ) {
    $pagenow = $GLOBALS['pagenow'];
    if ( 'index.php' === $pagenow ) {
        $show = true;
    }
    return $show;
} );
/**
 * Adds the Woo E-Invoicing admin menu.
 */
function admin_menu() {
}

/**
 * Woo E-Invoicing admin page, help with the onboarding.
 */
function plugin_page() {
    wp_safe_redirect( settings_url() );
    exit;
}

/**
 * WooCommerce notice settings, open to receive feedback.
 */
function notice_settings() {
    ?>
	<div class="notice notice-info is-dismissible" ><p>
	<?php 
    echo wp_kses_post( sprintf( 
        /* translators: 1: Url to the contact form. */
        __( 'Welcome to E-Invoicing For WooCommerce, feel to <a href="%s" >contact us</a> if you have any question or suggestion.', 'mi2u-eInvoice' ),
        esc_url( mi2u_fs()->contact_url() )
     ) );
    ?>
		</p><button type="button" class="notice-dismiss" onclick="this.parentNode.remove();" ></button>
	</div>
	<?php 
}

add_action( 'mi2u_ready', function () {
    if ( is_admin() ) {
        add_action( 'admin_menu', __NAMESPACE__ . '\\admin_menu' );
        add_action( 'woocommerce_before_settings_einvoicing', __NAMESPACE__ . '\\notice_settings' );
    }
} );
add_action( 'mi2u_before_templates', function () {
    ?>
		<p>
			<?php 
    esc_html_e( 'More prebuilt templates are available in premium version', 'mi2u-eInvoice' );
    ?>
		</p>
			<?php 
} );
